
// Copyright  2002-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_CUSTOM_H_
#define _NEUROSIS_ENGINE_CUSTOM_H_

/***************************************************************************/

class color3 {
	public:
		color3(float initR = 0.0f, float initG = 0.0f, float initB = 0.0f);
		//! Constructor/Deconstructor
		~color3();

		void	operator= (color3 rhs);
		bool	operator== (color3 rhs);
		//! Operators
		bool	operator!= (color3 rhs);

		float r, g, b;
};

/***************************************************************************/

class float2 {
	public:
		float2(float initX = 0.0f, float initY = 0.0f);
		//! Constructor/Deconstructor
		~float2();

		float2	operator+ (float2 rhs);
		float2	operator- (float2 rhs);
		float2	operator* (float rhs);
		float2	operator* (float2 rhs);
		float2	operator/ (float rhs);
		float2	operator/ (float2 rhs);
		void		operator= (float2 rhs);
		bool		operator== (float2 rhs);
		//! Operators
		bool		operator!= (float2 rhs);

		//! Gets the length
		float	Length();

		float x, y;
};

/***************************************************************************/

class float3 {
	public:
		float3(float initX = 0.0f, float initY = 0.0f, float initZ = 0.0f);
		//! Constructor/Deconstructor
		~float3();

		float3	operator+ (float3 rhs);
		float3	operator- (float3 rhs);
		float3	operator* (float rhs);
		float3	operator* (float3 rhs);
		float3	operator/ (float rhs);
		float3	operator/ (float3 rhs);
		void		operator= (float3 rhs);
		bool		operator== (float3 rhs);
		//! Operators
		bool		operator!= (float3 rhs);

		//! Gets the length
		float	Length();
		//! Sets the normalized triangle normal of the given points
		void	Normal(float3 *point1, float3 *point2, float3 *point3);
		//! Normalizes the value
		void	Normalize();
		//! Sets length of vector, and rotation based on the x axis (Pitch) [270.0f..90.0f] and z axis (Yaw) [0.0f..360.0f]
		void	Set(float length, float rotationX, float rotationZ);
		//! Sets rotation based on the x axis (Pitch) [270.0f..90.0f] and z axis (Yaw) [0.0f..360.0f], with original length
		void	Set(float rotationX, float rotationZ);
		//! Sets length of vector, with original rotation
		void	Set(float length);

		float x, y, z;
};

/***************************************************************************/

class int2 {
	public:
					int2(int initX = 0, int initY = 0);
		//! Constructor/Deconstructor
					~int2();

		int2	operator+ (int2 rhs);
		int2	operator- (int2 rhs);
		int2	operator* (int rhs);
		int2	operator* (int2 rhs);
		int2	operator/ (int rhs);
		int2	operator/ (int2 rhs);
		void	operator= (int2 rhs);
		bool	operator== (int2 rhs);
		//! Operators
		bool	operator!= (int2 rhs);

		int x, y;
};

/***************************************************************************/

class int3 {
	public:
					int3(int initX = 0, int initY = 0, int initZ = 0);
		//! Constructor/Deconstructor
					~int3();

		int3	operator+ (int3 rhs);
		int3	operator- (int3 rhs);
		int3	operator* (int rhs);
		int3	operator* (int3 rhs);
		int3	operator/ (int rhs);
		int3	operator/ (int3 rhs);
		void	operator= (int3 rhs);
		bool	operator== (int3 rhs);
		//! Operators
		bool	operator!= (int3 rhs);

		int x, y, z;
};

/***************************************************************************/
#endif